/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pipeline.programs;

import com.mojang.blaze3d.opengl.GlStateManager;
import java.util.function.Consumer;
import java.util.function.Function;
import net.irisshaders.iris.gl.shader.ShaderCompileException;
import net.irisshaders.iris.pipeline.programs.ShaderKey;
import net.irisshaders.iris.pipeline.programs.ShaderLoadingMap;
import net.irisshaders.iris.pipeline.programs.ShaderSupplier;
import net.minecraft.class_5944;

public class ShaderMap {
    private final class_5944[] shaders;

    public ShaderMap(ShaderLoadingMap loadingMap, Function<ShaderSupplier, Boolean> deletionFunction, Consumer<class_5944> programConsumer) {
        ShaderKey[] ids = ShaderKey.values();
        this.shaders = new class_5944[ids.length];
        loadingMap.forAllShaders((key, shader) -> {
            if (shader != null) {
                class_5944 shaderProgram;
                if (((Boolean)deletionFunction.apply((ShaderSupplier)shader)).booleanValue()) {
                    GlStateManager.glDeleteProgram((int)shader.id().program());
                    return;
                }
                this.checkLinkingState((ShaderKey)((Object)key), (ShaderSupplier)shader);
                this.shaders[key.ordinal()] = shaderProgram = shader.shader().get();
                programConsumer.accept(shaderProgram);
            }
        });
    }

    private void checkLinkingState(ShaderKey key, ShaderSupplier shader) {
        int i = shader.id().program();
        int j = GlStateManager.glGetProgrami((int)i, (int)35714);
        if (j == 0) {
            String string = GlStateManager.glGetProgramInfoLog((int)i, (int)32768);
            throw new ShaderCompileException(key.name(), string);
        }
    }

    public class_5944 getShader(ShaderKey id) {
        return this.shaders[id.ordinal()];
    }
}

