/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_12099;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import nx.pingwheel.common.config.ChannelMode;
import nx.pingwheel.common.config.ServerConfig;
import nx.pingwheel.common.resource.LanguageUtils;
import org.apache.logging.log4j.util.TriConsumer;

public class ServerCommandBuilder {
    private static final ServerConfig Config = ServerConfig.HANDLER.getConfig();

    private ServerCommandBuilder() {
    }

    public static LiteralArgumentBuilder<class_2168> build(TriConsumer<CommandContext<class_2168>, Boolean, class_5250> responseHandler) {
        LanguageUtils langDefaultChannel = LanguageUtils.command("default_channel");
        LanguageUtils langPlayerTracking = LanguageUtils.command("player_tracking");
        LanguageUtils langRegenTime = LanguageUtils.command("regen_time");
        LanguageUtils langRateLimit = LanguageUtils.command("rate_limit");
        List<ChannelMode> validModes = List.of(ChannelMode.values());
        List<String> validModeNames = validModes.stream().map(ChannelMode::toString).toList();
        LiteralArgumentBuilder cmdDefaultChannel = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"default_channel").executes(context -> {
            ChannelMode currentChannelMode = Config.getDefaultChannelMode();
            responseHandler.accept((Object)context, (Object)true, (Object)langDefaultChannel.path("get", "response").get(LanguageUtils.of("value", currentChannelMode.toString()).get(new Object[0]).method_27692(class_124.field_1054)));
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"mode_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CompletableFuture.supplyAsync(() -> {
            for (String mode : validModeNames) {
                builder.suggest(mode);
            }
            return builder.build();
        })).executes(context -> {
            String newModeStr = (String)context.getArgument("mode_name", String.class);
            ChannelMode newMode = validModes.stream().filter(e -> e.name().equalsIgnoreCase(newModeStr)).findFirst().orElse(null);
            if (newMode == null) {
                responseHandler.accept((Object)context, (Object)false, (Object)langDefaultChannel.path("set", "reject").get(String.join((CharSequence)" | ", validModeNames)));
                return 0;
            }
            Config.setDefaultChannelMode(newMode);
            ServerConfig.HANDLER.save();
            responseHandler.accept((Object)context, (Object)true, (Object)langDefaultChannel.path("set", "response").get(LanguageUtils.of("value", newMode.toString()).get(new Object[0]).method_27692(class_124.field_1054)));
            return 1;
        }));
        LiteralArgumentBuilder cmdPlayerTracking = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"player_tracking").executes(context -> {
            boolean isPlayerTrackingEnabled = Config.isPlayerTrackingEnabled();
            responseHandler.accept((Object)context, (Object)true, (Object)langPlayerTracking.path("get", "response").get(LanguageUtils.from(isPlayerTrackingEnabled).method_27692(class_124.field_1054)));
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"state", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            Boolean enablePlayerTracking = (Boolean)context.getArgument("state", Boolean.class);
            Config.setPlayerTrackingEnabled(enablePlayerTracking);
            ServerConfig.HANDLER.save();
            responseHandler.accept((Object)context, (Object)true, (Object)langPlayerTracking.path("set", "response").get(LanguageUtils.from(enablePlayerTracking).method_27692(class_124.field_1054)));
            return 1;
        }));
        LiteralArgumentBuilder cmdRegenTime = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"regen_time").executes(context -> {
            int regenTime = Config.getMsToRegenerate();
            responseHandler.accept((Object)context, (Object)true, (Object)langRegenTime.path("get", "response").get(LanguageUtils.from(regenTime).method_27692(class_124.field_1054)));
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"time", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Integer regenTime = (Integer)context.getArgument("time", Integer.class);
            Config.setMsToRegenerate(regenTime);
            ServerConfig.HANDLER.save();
            responseHandler.accept((Object)context, (Object)true, (Object)langRegenTime.path("set", "response").get(LanguageUtils.from(regenTime).method_27692(class_124.field_1054)));
            return 1;
        }));
        LiteralArgumentBuilder cmdRateLimit = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"rate_limit").executes(context -> {
            int rateLimit = Config.getRateLimit();
            responseHandler.accept((Object)context, (Object)true, (Object)langRateLimit.path("get", "response").get(LanguageUtils.from(rateLimit).method_27692(class_124.field_1054)));
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"limit", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Integer rateLimit = (Integer)context.getArgument("limit", Integer.class);
            Config.setRateLimit(rateLimit);
            ServerConfig.HANDLER.save();
            responseHandler.accept((Object)context, (Object)true, (Object)langRateLimit.path("set", "response").get(LanguageUtils.from(rateLimit).method_27692(class_124.field_1054)));
            return 1;
        }));
        Command helpCallback = context -> {
            responseHandler.accept((Object)context, (Object)true, (Object)LanguageUtils.join(class_2561.method_43473(), class_2561.method_43470((String)"/pingwheel:server default_channel"), langDefaultChannel.path("get", "description").wrapped().method_27692(class_124.field_1080), class_2561.method_43470((String)"/pingwheel:server default_channel <mode_name>"), langDefaultChannel.path("set", "description").wrapped().method_27692(class_124.field_1080), class_2561.method_43470((String)"/pingwheel:server player_tracking"), langPlayerTracking.path("get", "description").wrapped().method_27692(class_124.field_1080), class_2561.method_43470((String)"/pingwheel:server player_tracking true|false"), langPlayerTracking.path("set", "description").wrapped().method_27692(class_124.field_1080), class_2561.method_43470((String)"/pingwheel:server regen_time"), langRegenTime.path("get", "description").wrapped().method_27692(class_124.field_1080), class_2561.method_43470((String)"/pingwheel:server regen_time <milliseconds>"), langRegenTime.path("set", "description").wrapped().method_27692(class_124.field_1080), class_2561.method_43470((String)"/pingwheel:server rate_limit"), langRateLimit.path("get", "description").wrapped().method_27692(class_124.field_1080), class_2561.method_43470((String)"/pingwheel:server rate_limit <limit>"), langRateLimit.path("set", "description").wrapped().method_27692(class_124.field_1080)));
            return 1;
        };
        LiteralArgumentBuilder cmdHelp = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"help").executes(helpCallback);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"pingwheel:server").requires(source -> source.method_75037().hasPermission(class_12099.field_63210))).executes(helpCallback)).then((ArgumentBuilder)cmdHelp)).then((ArgumentBuilder)cmdDefaultChannel)).then((ArgumentBuilder)cmdPlayerTracking)).then((ArgumentBuilder)cmdRegenTime)).then((ArgumentBuilder)cmdRateLimit);
    }
}

