/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.natives;

import de.maxhenkel.opus4j.OpusEncoder;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import de.maxhenkel.voicechat.api.opus.OpusEncoder;
import de.maxhenkel.voicechat.api.opus.OpusEncoderMode;
import de.maxhenkel.voicechat.intercompatibility.CrossSideManager;
import de.maxhenkel.voicechat.natives.NativeValidator;
import de.maxhenkel.voicechat.plugins.impl.opus.JavaOpusDecoderImpl;
import de.maxhenkel.voicechat.plugins.impl.opus.JavaOpusEncoderImpl;
import de.maxhenkel.voicechat.plugins.impl.opus.NativeOpusDecoderImpl;
import de.maxhenkel.voicechat.plugins.impl.opus.NativeOpusEncoderImpl;

public class OpusManager
extends NativeValidator {
    private static OpusManager instance;

    @Override
    protected void runValidation() throws Throwable {
        NativeOpusEncoderImpl encoder = new NativeOpusEncoderImpl(48000, 1, OpusEncoder.Application.VOIP);
        encoder.setMaxPayloadSize(1024);
        byte[] encoded = encoder.encode(new short[960]);
        encoder.resetState();
        encoder.close();
        NativeOpusDecoderImpl decoder = new NativeOpusDecoderImpl(48000, 1);
        decoder.setFrameSize(960);
        decoder.decode(encoded);
        decoder.decode(null);
        decoder.resetState();
        decoder.close();
    }

    @Override
    protected String getNativeName() {
        return "Opus";
    }

    public static OpusEncoder createEncoder(OpusEncoderMode mode) {
        OpusManager instance = OpusManager.instance();
        int mtuSize = CrossSideManager.get().getMtuSize();
        OpusEncoder.Application application = OpusEncoder.Application.VOIP;
        if (mode != null) {
            switch (mode) {
                default: {
                    throw new MatchException(null, null);
                }
                case VOIP: {
                    OpusEncoder.Application application2 = OpusEncoder.Application.VOIP;
                    break;
                }
                case AUDIO: {
                    OpusEncoder.Application application2 = OpusEncoder.Application.AUDIO;
                    break;
                }
                case RESTRICTED_LOWDELAY: {
                    OpusEncoder.Application application2 = application = OpusEncoder.Application.LOW_DELAY;
                }
            }
        }
        if (instance.canUse()) {
            try {
                NativeOpusEncoderImpl encoder = new NativeOpusEncoderImpl(48000, 1, application);
                encoder.setMaxPayloadSize(mtuSize);
                return encoder;
            }
            catch (Throwable e) {
                instance.setFailed(e.getMessage());
                Voicechat.LOGGER.warn("Failed to load native Opus encoder - Falling back to Java Opus implementation", new Object[0]);
            }
        }
        return new JavaOpusEncoderImpl(48000, 960, mtuSize, application);
    }

    public static OpusDecoder createDecoder() {
        OpusManager instance = OpusManager.instance();
        if (instance.canUse()) {
            try {
                NativeOpusDecoderImpl decoder = new NativeOpusDecoderImpl(48000, 1);
                decoder.setFrameSize(960);
                return decoder;
            }
            catch (Throwable e) {
                instance.setFailed(e.getMessage());
                Voicechat.LOGGER.warn("Failed to load native Opus decoder - Falling back to Java Opus implementation", new Object[0]);
            }
        }
        return new JavaOpusDecoderImpl(48000, 960);
    }

    public static void init() {
        OpusManager.instance().initialize();
    }

    public static boolean isFailed() {
        return !OpusManager.instance().canUse();
    }

    public static String getFailedMessage() {
        return OpusManager.instance().getMessage();
    }

    private static synchronized OpusManager instance() {
        if (instance == null) {
            instance = new OpusManager();
        }
        return instance;
    }
}

